{  Copyright 2005 Allen Datagraph Systems - All Rights Reserved
   Permission is given to owners of Allen Datagraph 9240 chart recorders to use
   and modify this program for the purpose of talking to the Allen Datagraph
   9240 strip chart recorder.

   The options units is responsible for saving all values that are persistant
   through power off/on
}
unit Option;

interface

uses windows, messages;

const
  WM_LogMessage = WM_USER;
type

  Toption = class
    private
      { Private declarations }
      FLptPort                 : string;        // parallel port used

    public
      // dummy vars to make compile
      constructor create;
      procedure   load;
      procedure   save;
      property LPTPort                 : String        read FLPTPort                write FLptPort;
  end;

var
  opt : TOption;

implementation

uses sysutils, registry;

var
  reg : TRegistry;

function GetString(valueString : string; default : string) : string;
begin
  result := reg.readstring(valuestring);
  if result = '' then result := default;
end;

////////////////////////////////////////////////////////////////////////////////

constructor Toption.create;
begin
  inherited create;
  load;
end;


procedure Toption.Load;
begin
  Reg := TRegistry.Create;
  try
    Reg.RootKey := HKEY_CURRENT_USER;
    if Reg.OpenKey('\Software\Allen Datagraph Systems\Port9240', True) then
    begin
      FLptPort := GetString('Lpt Port','lpt1');
    end;
  finally
    Reg.CloseKey;
    reg.free;
    inherited;
  end;
end;

procedure Toption.Save;
begin
  Reg := TRegistry.Create;
  try
    Reg.RootKey := HKEY_CURRENT_USER;
    if Reg.OpenKey('\Software\Allen Datagraph Systems\Port9240', True) then
    begin
      Reg.Writestring  ('Lpt Port', FLPTPort);
    end;
  finally
    Reg.CloseKey;
    freeandnil(Reg);
    inherited;
  end;
end;


initialization
  Opt := TOption.Create;

end.
